package com.m2;

import java.util.*;
import java.rmi.*;


public class mpiClient {
	
	private static threadClient[] client;
	private static int[] clientMask;
	
	public static void main(String[] args){
		System.out.println("Client starting...");
		Date time=new Date();
		int N=3000;
		int P=0;
		if(args.length>0)
			P=args.length;
		else
			P=1;
		// int[][] matrix=new int[N][N];

		int[][] MA=new int[N][N];
		int[][] MB=new int[N][N];
		int[][] MF=new int[N][N];
		int[][] MR=new int[N][N];
		int[][] MZ=new int[N][N];

		int[] vector=new int[N];
		
		Random gen=new Random();
		for(int i=0;i<N;i++){
			for(int j=0;j<N;j++)
			        {
				MA[i][j]=gen.nextInt(100);
				MB[i][j]=gen.nextInt(100);
				MF[i][j]=gen.nextInt(100);
				MR[i][j]=gen.nextInt(100);
			       }
			vector[i]=gen.nextInt(100);
		};
		long startTime=time.getTime();		
		client=new threadClient[P];
		clientMask=new int[P];
		for(int i=0;i<P;i++){
			String url="";
			if(args.length>0)
				url=args[i];
			else
				url="192.168.1.5";
			//int[][] MZ=new int[N][(int)(N/P)];
			for(int j=0;j<N;j++)
				System.arraycopy(MA[j],(int)(N*i/P),MZ[j],0,(int)(N/P));
			client[i]=new threadClient(vector,MZ,url);
			client[i].start();
		}
		
		int min=0;

		for(int j=0;j<N;j++)
		{
		      for(int i=0;i<N;i++)
		            {
			MZ[i][j] = (MB[i][j] + MF[i][j]) * (MA[i][j] - MR[i][j]);
		            }
		}
		time=new Date();
		long endTime=time.getTime();
		System.out.println(min);
		System.out.println(endTime-startTime);
		System.out.println("Client end.");
	}
	private static boolean nonExecute(){
		for(int i=0;i<clientMask.length;i++)
			if(clientMask[i]==0)
				return true;
		return false;
	}
	private static int getExecute(){
		for(int i=0;i<client.length;i++)
			if(client[i].isAlive()==false&&clientMask[i]==0)
				return i;
		return -1;
	}
}

class threadClient extends Thread{
	private int[] vector;
	private int[][] MA;
	private String IPAddres;
	private int min;

	public threadClient(int[] A, int[][] MZ, String addres) {
		super();
		vector = A;
		MA = MZ;
		IPAddres = addres;
	}
	
	public void run(){
		try{
			mpi rmiConnect=(mpi)Naming.lookup("rmi://"+IPAddres+"/server");
			min=rmiConnect.getMinimum(vector, MA);
		}catch(Exception e){
			e.printStackTrace();
		}
	}

	public int getMin() {
		return min;
	}
}
